//==============================================================================
// MpiSuspendMessage
//==============================================================================

/*:
 * @plugindesc 文章の表示を一時中断
 * @author 奏ねこま（おとぶき ねこま）
 *
 * @param Suspend Switch ID
 * @type switch
 * @desc 文章の表示を一時中断させるスイッチの番号を指定してください。
 * @default 0
 * 
 * @help
 * [説明]
 *  指定のスイッチがONになっている状態で「文章の表示」イベントを実行すると、
 *  文章を表示したあともウインドウを閉じず、その次の「文章の表示」イベント時に、
 *  現在表示している文章から続けて表示します。
 * 
 * [使い方]
 *  一時中断させたい「文章の表示」イベントの直前で、プラグインパラメータで指定し
 *  たスイッチをONにします。
 *  スイッチをONにした状態で実行した「文章の表示」イベントが一時中断対象となりま
 *  すので、通常の動作をさせたい場合はイベント実行前にOFFにしてください。
 * 
 * [補足]
 *  一時中断時でも入力待ちは発生します。一時中断～次の文章表示をノンストップで行
 *  いたい場合は、制御文字の「\^」をご利用ください。
 *  制御文字についてはRPGツクールMVのヘルプ、もしくは「文章の表示」イベント設定
 *  画面で入力欄にマウスカーソルを合わせたときに表示される説明をご参照ください。
 * 
 * [利用規約] ..................................................................
 *  - 本プラグインの利用は、RPGツクールMV/RPGMakerMVの正規ユーザーに限られます。
 *  - 商用、非商用、有償、無償、一般向け、成人向けを問わず、利用可能です。
 *  - 利用の際、連絡や報告は必要ありません。また、製作者名の記載等も不要です。
 *  - プラグインを導入した作品に同梱する形以外での再配布、転載はご遠慮ください。
 *  - 本プラグインにより生じたいかなる問題についても、一切の責任を負いかねます。
 * [改訂履歴] ..................................................................
 *   Version 1.02  2018/07/13  YEP_MessageCore.js+Rubi_riru.js（riru様）の競合対策
 *   Version 1.01  2018/06/27  YEP_MessageCore.js（Yanfly様）の競合対策
 *   Version 1.00  2018/05/18  初版
 * -+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-
 *  Web Site: http://makonet.sakura.ne.jp/rpg_tkool/
 *  Twitter : https://twitter.com/koma_neko
 *  Copylight (c) 2018 Nekoma Otobuki
 */

var Imported = Imported || {};
var Makonet = Makonet || {};

(function(){
	'use strict';

    var plugin = 'MpiSuspendMessage';

    Imported[plugin] = true;
    Makonet[plugin] = {};

    var $mpi = Makonet[plugin];
    $mpi.parameters = PluginManager.parameters(plugin);

    $mpi.switchId = Number($mpi.parameters['Suspend Switch ID']) || 0;

    //==============================================================================
    // Window_Message
    //==============================================================================

    (function(o,p){
		var f=o[p];o[p]=function(){
            return f.apply(this,arguments) || !!$gameSystem._MSM_textState;
		};
	}(Window_Message.prototype,'doesContinue'));

    (function(o,p){
		var f=o[p];o[p]=function(){
            var _contents = this.contents;
            var _clear = this.contents.clear;
            if ($gameSystem._MSM_textState) {
                this.contents.clear = function(){};
            }
            f.apply(this,arguments);
            var _y = this._textState.y;
            if ($gameSystem._MSM_textState) {
                this._textState = $gameSystem._MSM_textState;
                this._textState.text += this.convertEscapeCharacters($gameMessage.allText());
                $gameSystem._MSM_textState = null;
                if (this.contents === _contents) {
                    this.contents.clear = _clear;
                }
                if (this.contents !== $gameTemp._MSM_contents) {
                    var _index = this._textState.index;
                    this._textState.index = 0;
                    this.newPage(this._textState);
                    this._textState.y = _y;
                    while (this._textState.index < _index) {
                        this.processCharacter(this._textState);
                    }
                    this.clearFlags();
                    $gameTemp._MSM_contents = this.contents;
                }
            }
		};
	}(Window_Message.prototype,'startMessage'));

    (function(o,p){
		var f=o[p];o[p]=function(){
            if ($mpi.switchId && $gameSwitches.value($mpi.switchId)) {
                $gameSystem._MSM_textState = this._textState;
                $gameTemp._MSM_contents = this.contents;
            }
            f.apply(this,arguments);
		};
	}(Window_Message.prototype,'onEndOfText'));
}());
